/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLineMiddleToCenter.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cApplication.h"
#include "cLine.h"

//	Creates a line using the mid point of the given line and the
//	center point of the given circle and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLineMiddleToCenter(ILine *line1, ILine *circle1, ILine **newLine1)
{

	START_METHOD("CreateLineMiddleToCenter")

	HRESULT status = CONV_SUCCESS;

	// Get the mid point of the line
	IPoint *midPoint1 = NULL;
	status = GetMidPoint(line1, &midPoint1);
	CHECK_RETURN_STATUS(status)

	// Get the center point of the circle
	IPoint *centerPoint1 = NULL;
	status = circle1->GetCenterPoint(&centerPoint1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLinePointToPoint(midPoint1, centerPoint1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*newLine1 = pLine1;

	END_METHOD("CreateLineMiddleToCenter")
}
